<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->id('Currency_id');
            $table->string('Code', 3)->unique()->comment('e.g., INR, USD');
            $table->string('Symbol', 5)->comment('e.g., ₹, $');
            $table->decimal('Exchange_rate', 10, 4)->default(1.0000)->comment('Rate relative to base currency');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
